<?php
/**
 * Metaboxes class
 *
 * @package Houzez_Offplan_Search
 */

if (!defined('ABSPATH')) {
    exit;
}

class Houzez_Offplan_Metaboxes {
    
    /**
     * Constructor
     */
    public function __construct() {
        add_action('add_meta_boxes', array($this, 'add_metabox'));
        add_action('save_post', array($this, 'save_metabox'), 10, 2);
    }
    
    /**
     * Add metabox
     */
    public function add_metabox() {
        // Add metabox to all pages and posts (since shortcode can be used anywhere)
        add_meta_box(
            'houzez_offplan_settings',
            esc_html__('Off-Plan Search Shortcode', 'houzez-offplan-search'),
            array($this, 'render_metabox'),
            array('page', 'post'),
            'side',
            'default'
        );
    }
    
    /**
     * Render metabox
     */
    public function render_metabox($post) {
        // Add nonce for security
        wp_nonce_field('houzez_offplan_metabox', 'houzez_offplan_metabox_nonce');
        
        ?>
        <div class="houzez-offplan-shortcode-info">
            <p><strong><?php esc_html_e('Shortcode:', 'houzez-offplan-search'); ?></strong></p>
            <code>[houzez_offplan_search]</code>
            
            <p><strong><?php esc_html_e('Available Attributes:', 'houzez-offplan-search'); ?></strong></p>
            <ul style="margin-left: 20px;">
                <li><code>card_style</code> - v1, v2, v3, v4, v5, v6, v7 (default: v7)</li>
                <li><code>posts_per_page</code> - Number of properties per page (default: theme setting)</li>
                <li><code>columns</code> - Number of columns: 2, 3, or 4 (default: 2)</li>
                <li><code>show_filters</code> - yes/no (default: yes)</li>
                <li><code>show_sort</code> - yes/no (default: yes)</li>
            </ul>
            
            <p><strong><?php esc_html_e('Examples:', 'houzez-offplan-search'); ?></strong></p>
            <code>[houzez_offplan_search card_style="v5"]</code><br>
            <code>[houzez_offplan_search card_style="v3" posts_per_page="12"]</code><br>
            <code>[houzez_offplan_search columns="3"]</code><br>
            <code>[houzez_offplan_search columns="4" card_style="v7"]</code><br>
            <code>[houzez_offplan_search show_filters="no"]</code>
        </div>
        <?php
    }
    
    /**
     * Save metabox (not needed for shortcode, but keeping for consistency)
     */
    public function save_metabox($post_id, $post) {
        // No need to save anything for shortcode
        return;
    }
}

