<?php
/**
 * Main plugin class
 *
 * @package Houzez_Offplan_Search
 */

if (!defined('ABSPATH')) {
    exit;
}

class Houzez_Offplan_Search {
    
    /**
     * Instance
     */
    private static $instance = null;
    
    /**
     * Get instance
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Initialize
     */
    public function init() {
        // Enqueue scripts and styles
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'));
        
        // Initialize other classes
        if (class_exists('Houzez_Offplan_Filters')) {
            new Houzez_Offplan_Filters();
        }
        
        if (class_exists('Houzez_Offplan_Ajax')) {
            new Houzez_Offplan_Ajax();
        }
        
        // Shortcode is initialized in main plugin file
    }
    
    
    /**
     * Enqueue scripts and styles
     * Note: Scripts are now enqueued directly by the shortcode when rendered
     * This method is kept for backward compatibility but may not be needed
     */
    public function enqueue_scripts() {
        // Scripts are enqueued by shortcode class when rendered
        // This ensures scripts only load when shortcode is actually used
    }
    
    /**
     * Get template path
     */
    public static function get_template_path($template_name) {
        // Check if theme has override
        $theme_template = locate_template(array('houzez-offplan/' . $template_name));
        
        if ($theme_template) {
            return $theme_template;
        }
        
        // Use plugin template
        return HOUZEZ_OFFPLAN_PLUGIN_DIR . 'templates/' . $template_name;
    }
    
    /**
     * Load template part
     */
    public static function get_template_part($template_name, $args = array()) {
        $template_path = self::get_template_path($template_name);
        
        if (file_exists($template_path)) {
            extract($args);
            include $template_path;
        }
    }
}

