<?php
/**
 * Status-based search forms shortcode
 *
 * Renders multiple Houzez-style search forms (one per property_status term).
 * Each form submits via GET to the Houzez search results page.
 *
 * @package Houzez_Offplan_Search
 */

if (!defined('ABSPATH')) {
    exit;
}

class Houzez_Status_Forms_Shortcode {

    /**
     * Constructor
     */
    public function __construct() {
        add_shortcode('houzez_status_forms_search', array($this, 'render_shortcode'));
    }

    /**
     * Render shortcode
     *
     * @param array  $atts    Shortcode attributes.
     * @param string $content Shortcode content.
     * @return string Shortcode output.
     */
    public function render_shortcode($atts = array(), $content = null) {
        if (!function_exists('houzez_option')) {
            return '<div class="houzez-offplan-error"><p>' . esc_html__('Houzez theme is required for this shortcode to work.', 'houzez-offplan-search') . '</p></div>';
        }

        if (!function_exists('houzez_get_search_template_link')) {
            return '<div class="houzez-offplan-error"><p>' . esc_html__('Houzez search template link is required. Please ensure Houzez theme is up to date.', 'houzez-offplan-search') . '</p></div>';
        }

        $this->enqueue_assets();

        $atts = shortcode_atts(array(
            'status' => '',
        ), is_array($atts) ? $atts : array(), 'houzez_status_forms_search');

        $status_slug = !empty($atts['status']) ? sanitize_text_field($atts['status']) : '';

        ob_start();
        $template = HOUZEZ_OFFPLAN_PLUGIN_DIR . 'templates/status-forms-search.php';
        if (file_exists($template)) {
            $status_filter = $status_slug;
            include $template;
        } else {
            echo '<p>' . esc_html__('Status forms template not found.', 'houzez-offplan-search') . '</p>';
        }
        return ob_get_clean();
    }

    /**
     * Enqueue CSS for status forms (scoped to this shortcode).
     */
    private function enqueue_assets() {
        static $enqueued = false;
        if ($enqueued) {
            return;
        }
        $enqueued = true;

        $css_file = HOUZEZ_OFFPLAN_PLUGIN_DIR . 'assets/css/status-forms-search.css';
        if (file_exists($css_file)) {
            wp_enqueue_style(
                'houzez-status-forms-search',
                HOUZEZ_OFFPLAN_PLUGIN_URL . 'assets/css/status-forms-search.css',
                array(),
                HOUZEZ_OFFPLAN_VERSION
            );
        }
    }
}
