<?php
/**
 * Off-Plan Search Filters Template
 * 
 * @var array $args Template arguments
 */

if (!defined('ABSPATH')) {
    exit;
}

$card_style = isset($args['card_style']) ? $args['card_style'] : 'v7';

// Get current filter values from URL
$current_area = isset($_GET['areas']) ? $_GET['areas'] : '';
$current_developer = isset($_GET['developer']) ? sanitize_text_field($_GET['developer']) : '';
$current_projects = isset($_GET['projects']) ? $_GET['projects'] : '';

// Check if Houzez functions exist
$houzez_option_exists = function_exists('houzez_option');
$houzez_get_search_taxonomies_exists = function_exists('houzez_get_search_taxonomies');
$houzez_ajax_search_exists = function_exists('houzez_ajax_search');
$houzez_multiselect_exists = function_exists('houzez_multiselect');
$houzez_is_multiselect_exists = function_exists('houzez_is_multiselect');
?>

<div class="offplan-search-filters mb-4">
    <div class="filter-bar">
        <form id="offplan-search-form" method="get" action="">
            <div class="row g-3 align-items-end">
                <!-- Community Filter (property_area) -->
                <div class="col-md-4 col-lg-3">
                    <div class="offplan-filter-wrap form-group">
                        <label for="offplan-area" class="form-label">
                            <?php echo $houzez_option_exists ? esc_html(houzez_option('srh_areas', 'Community')) : esc_html__('Community', 'houzez-offplan-search'); ?>
                        </label>
                        <select name="areas[]" 
                                id="offplan-area" 
                                data-size="5" 
                                class="selectpicker offplan-filter form-control bs-select-hidden" 
                                title="<?php esc_attr_e('Any', 'houzez-offplan-search'); ?>" 
                                data-live-search="true" 
                                data-selected-text-format="count > 1" 
                                data-actions-box="false"
                                <?php echo $houzez_multiselect_exists ? houzez_multiselect($houzez_option_exists ? houzez_option('ms_area', 0) : 0) : ''; ?>
                                data-live-search-normalize="true"
                                data-select-all-text="<?php echo $houzez_option_exists ? esc_attr(houzez_option('cl_select_all', 'Select All')) : esc_attr__('Select All', 'houzez-offplan-search'); ?>"
                                data-deselect-all-text="<?php echo $houzez_option_exists ? esc_attr(houzez_option('cl_deselect_all', 'Deselect All')) : esc_attr__('Deselect All', 'houzez-offplan-search'); ?>"
                                data-none-results-text="<?php echo $houzez_option_exists ? esc_attr(houzez_option('cl_no_results_matched', 'No results matched')) : esc_attr__('No results matched', 'houzez-offplan-search'); ?> {0}"
                                data-count-selected-text="{0} <?php echo $houzez_option_exists ? esc_attr(houzez_option('srh_areass', 'Areas')) : esc_attr__('Areas', 'houzez-offplan-search'); ?>">
                            <?php
                            if ($houzez_is_multiselect_exists && !houzez_is_multiselect($houzez_option_exists ? houzez_option('ms_area', 0) : 0)) {
                                echo '<option value="">' . ($houzez_option_exists ? esc_html(houzez_option('srh_areas', 'Any')) : esc_html__('Any', 'houzez-offplan-search')) . '</option>';
                            }
                            
                            // Get all terms and filter to only show those with off-plan properties
                            $areas = get_terms(array(
                                'taxonomy' => 'property_area',
                                'hide_empty' => false,
                            ));
                            
                            if (!is_wp_error($areas) && !empty($areas)) {
                                foreach ($areas as $area) {
                                    // Check if this term has off-plan properties
                                    if (!Houzez_Offplan_Filters::term_has_offplan_properties($area, 'property_area')) {
                                        continue;
                                    }
                                    
                                    $selected = '';
                                    if (is_array($current_area) && in_array($area->slug, $current_area)) {
                                        $selected = 'selected';
                                    } elseif ($current_area == $area->slug) {
                                        $selected = 'selected';
                                    }
                                    $count = Houzez_Offplan_Filters::get_term_offplan_count($area, 'property_area');
                                    echo '<option value="' . esc_attr($area->slug) . '" ' . $selected . '>' . esc_html($area->name) . ' (' . $count . ')</option>';
                                }
                            }
                            ?>
                        </select>
                        <button type="button" class="offplan-filter-clear" data-target="offplan-area" aria-label="<?php esc_attr_e('Clear', 'houzez-offplan-search'); ?>">×</button>
                    </div>
                </div>

                <!-- Projects Filter (property_developers) -->
                <div class="col-md-4 col-lg-3">
                    <div class="offplan-filter-wrap form-group">
                        <label for="offplan-projects" class="form-label">
                            <?php esc_html_e('Projects', 'houzez-offplan-search'); ?>
                        </label>
                        <select name="projects[]" 
                                id="offplan-projects" 
                                data-size="5" 
                                class="selectpicker offplan-filter form-control bs-select-hidden" 
                                title="<?php esc_attr_e('Any', 'houzez-offplan-search'); ?>" 
                                data-live-search="true" 
                                data-selected-text-format="count > 1" 
                                data-actions-box="false"
                                data-live-search-normalize="true"
                                data-select-all-text="<?php esc_attr_e('Select All', 'houzez-offplan-search'); ?>"
                                data-deselect-all-text="<?php esc_attr_e('Deselect All', 'houzez-offplan-search'); ?>"
                                data-none-results-text="<?php esc_attr_e('No results matched', 'houzez-offplan-search'); ?> {0}"
                                data-count-selected-text="{0} <?php esc_attr_e('Projects', 'houzez-offplan-search'); ?>">
                            <option value=""><?php esc_html_e('Any', 'houzez-offplan-search'); ?></option>
                            <?php
                            // Get property_developers taxonomy terms
                            $projects = get_terms(array(
                                'taxonomy' => 'property_developers',
                                'hide_empty' => false,
                            ));
                            
                            if (!is_wp_error($projects) && !empty($projects)) {
                                foreach ($projects as $project) {
                                    // Check if this term has off-plan properties
                                    if (!Houzez_Offplan_Filters::term_has_offplan_properties($project, 'property_developers')) {
                                        continue;
                                    }
                                    
                                    $selected = '';
                                    if (is_array($current_projects) && in_array($project->slug, $current_projects)) {
                                        $selected = 'selected';
                                    } elseif ($current_projects == $project->slug) {
                                        $selected = 'selected';
                                    }
                                    echo '<option value="' . esc_attr($project->slug) . '" ' . $selected . '>' . esc_html($project->name) . '</option>';
                                }
                            }
                            ?>
                        </select>
                        <button type="button" class="offplan-filter-clear" data-target="offplan-projects" aria-label="<?php esc_attr_e('Clear', 'houzez-offplan-search'); ?>">×</button>
                    </div>
                </div>

                <!-- Developer Filter (property_developers) -->
                <div class="col-md-4 col-lg-3">
                    <div class="offplan-filter-wrap form-group">
                        <label for="offplan-developer" class="form-label">
                            <?php esc_html_e('Developer', 'houzez-offplan-search'); ?>
                        </label>
                        <select name="developer" 
                                id="offplan-developer" 
                                data-size="5" 
                                class="selectpicker offplan-filter form-control bs-select-hidden" 
                                title="<?php esc_attr_e('Any', 'houzez-offplan-search'); ?>" 
                                data-live-search="true" 
                                data-live-search-normalize="true"
                                data-none-results-text="<?php esc_attr_e('No results matched', 'houzez-offplan-search'); ?> {0}">
                            <option value=""><?php esc_html_e('Any', 'houzez-offplan-search'); ?></option>
                            <?php
                            // Get property_developers taxonomy terms
                            $developers = get_terms(array(
                                'taxonomy' => 'property_developers',
                                'hide_empty' => false,
                            ));
                            
                            if (!is_wp_error($developers) && !empty($developers)) {
                                foreach ($developers as $developer) {
                                    // Check if this term has off-plan properties
                                    if (!Houzez_Offplan_Filters::term_has_offplan_properties($developer, 'property_developers')) {
                                        continue;
                                    }
                                    
                                    $selected = ($current_developer == $developer->slug) ? 'selected' : '';
                                    $count = Houzez_Offplan_Filters::get_term_offplan_count($developer, 'property_developers');
                                    echo '<option value="' . esc_attr($developer->slug) . '" ' . $selected . '>' . esc_html($developer->name) . ' (' . $count . ')</option>';
                                }
                            }
                            ?>
                        </select>
                        <button type="button" class="offplan-filter-clear" data-target="offplan-developer" aria-label="<?php esc_attr_e('Clear', 'houzez-offplan-search'); ?>">×</button>
                    </div>
                </div>

                <!-- Search Button -->
                <div class="col-md-12 col-lg-auto offplan-search-btn-wrapper">
                    <div class="form-group">
                        <button type="button" id="offplan-search-btn" class="btn btn-primary">
                            <?php esc_html_e('Search', 'houzez-offplan-search'); ?>
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Hidden fields -->
            <input type="hidden" name="card_style" value="<?php echo esc_attr($card_style); ?>" />
            <input type="hidden" name="page_id" value="<?php echo esc_attr(get_the_ID()); ?>" />
        </form>
    </div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Initialize selectpicker if available
    if (typeof $.fn.selectpicker !== 'undefined') {
        $('.selectpicker').selectpicker('refresh');
    }
    // Per-field clear visibility is updated by offplan-search.js (updateFilterClearVisibility)
    if (typeof HouzezOffplanSearch !== 'undefined' && HouzezOffplanSearch.updateFilterClearVisibility) {
        setTimeout(function() { HouzezOffplanSearch.updateFilterClearVisibility(); }, 200);
    }
});
</script>

