<?php
/**
 * Template Name: Off-Plan Search
 * 
 * Off-plan property search page with AJAX filtering
 */

get_header();

global $post;

// Get card style from post meta, default to v7
$card_style = get_post_meta($post->ID, 'houzez_offplan_card_style', true);
if (empty($card_style)) {
    $card_style = 'v7';
}

// Validate card style
$valid_card_styles = array('v1', 'v2', 'v3', 'v4', 'v5', 'v6', 'v7');
if (!in_array($card_style, $valid_card_styles, true)) {
    $card_style = 'v7';
}

// Set up query arguments for off-plan properties
$listing_args = array(
    'post_type' => 'property',
    'post_status' => 'publish',
    'posts_per_page' => function_exists('houzez_option') ? absint(houzez_option('search_num_posts')) : 9,
    'paged' => max(1, get_query_var('paged') ?: get_query_var('page')),
);

if (!$listing_args['posts_per_page']) {
    $listing_args['posts_per_page'] = 9;
}

// Apply filters (this will add off-plan status filter via our filter class)
$listing_args = apply_filters('houzez20_property_filter', $listing_args);

// Apply sorting
if (function_exists('houzez_prop_sort')) {
    $listing_args = houzez_prop_sort($listing_args);
}

// Create query
$listings_query = new WP_Query($listing_args);
$total_listing_found = $listings_query->found_posts;

// Get number of properties per page
$fave_prop_no = get_post_meta($post->ID, 'fave_prop_no', true);
$fave_prop_no = !empty($fave_prop_no) ? (int)$fave_prop_no : $listing_args['posts_per_page'];

// Container class
$container_class = 'container';

// Layout CSS class for grid
$listing_view_class = 'listing-view grid-view row row-cols-1 row-cols-md-2 gy-4 gx-4';

$max_num_pages = $listings_query->max_num_pages;

$class_margin = '';
if ($max_num_pages <= 1) {
    $class_margin = 'mb-4';
}
?>

<section class="listing-wrap listing-offplan-search <?php echo esc_attr($class_margin); ?>" role="region">
    <?php do_action('houzez_before_listing_wrap'); ?>
    <div class="<?php echo esc_attr($container_class); ?>">
        <div class="page-title-wrap">
            <?php get_template_part('template-parts/page/breadcrumb'); ?>
            <div class="d-flex align-items-center">
                <?php get_template_part('template-parts/page/page-title'); ?>
            </div><!-- d-flex -->
        </div><!-- page-title-wrap -->

        <!-- Filter Bar -->
        <?php 
        $filter_template = HOUZEZ_OFFPLAN_PLUGIN_DIR . 'templates/offplan-filters.php';
        if (file_exists($filter_template)) {
            $args = array('card_style' => $card_style);
            extract($args);
            include $filter_template;
        }
        ?>

        <div class="row">
            <div class="col-lg-12 col-md-12">
                <?php do_action('houzez_before_listing_content'); ?>
                
                <!-- Sort Options -->
                <?php if (function_exists('get_template_part')) {
                    $sort_template = locate_template(array('template-parts/listing/listing-sort-by.php'));
                    if ($sort_template) {
                        get_template_part('template-parts/listing/listing', 'sort-by');
                    }
                } ?>

                <!-- Results Container (AJAX Target) -->
                <div id="offplan-results-container" class="<?php echo esc_attr($listing_view_class); ?>" 
                     role="list" 
                     data-view="grid" 
                     data-card-style="<?php echo esc_attr($card_style); ?>"
                     data-page-id="<?php echo esc_attr($post->ID); ?>">
                    <?php do_action('houzez_before_listing_items'); ?>
                    <?php
                    if ($listings_query->have_posts()) :
                        while ($listings_query->have_posts()) : $listings_query->the_post();
                            // Load Houzez theme template part
                            $template_path = locate_template(array('template-parts/listing/item-' . $card_style . '.php'));
                            if ($template_path) {
                                get_template_part('template-parts/listing/item', $card_style);
                            } else {
                                // Fallback to v1 if card style template doesn't exist
                                get_template_part('template-parts/listing/item', 'v1');
                            }
                        endwhile;
                        wp_reset_postdata();
                    else:
                        get_template_part('template-parts/listing/item-none');
                    endif;
                    ?>
                </div><!-- listing-view -->
                
                <!-- Pagination -->
                <?php 
                if (function_exists('houzez_pagination')) {
                    houzez_pagination($listings_query->max_num_pages, $total_listing_found, $fave_prop_no);
                } else {
                    // Basic pagination fallback
                    $pagination = paginate_links(array(
                        'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
                        'total' => $listings_query->max_num_pages,
                        'current' => max(1, get_query_var('paged') ?: get_query_var('page')),
                        'format' => '?paged=%#%',
                        'show_all' => false,
                        'type' => 'list',
                        'end_size' => 2,
                        'mid_size' => 1,
                        'prev_next' => true,
                        'prev_text' => '&laquo;',
                        'next_text' => '&raquo;',
                    ));
                    echo $pagination;
                }
                ?>
                <?php do_action('houzez_after_listing_items'); ?>
            </div><!-- col-lg-12 -->
        </div><!-- row -->
    </div><!-- container -->
    <?php do_action('houzez_after_listing_wrap'); ?>
</section><!-- listing-wrap -->

<?php
get_footer();

