<?php
/**
 * Plugin Name: Houzez Banner Search
 * Description: Adds a status-tab + area autocomplete search widget with AJAX results, integrated with Houzez search templates.
 * Version: 1.0.1
 * Text Domain: houzez-banner-search
 */

if (!defined('ABSPATH')) {
    exit;
}

// Define constants
define('HOUZEZ_SAS_VERSION', '1.0.0');
define('HOUZEZ_SAS_PATH', plugin_dir_path(__FILE__));
define('HOUZEZ_SAS_URL', plugin_dir_url(__FILE__));

// Ensure Houzez theme functions exist
function houzez_sas_check_theme() {
    return function_exists('houzez_option');
}

// Admin notice if Houzez is not active
function houzez_sas_admin_notice() {
    if (!houzez_sas_check_theme()) {
        echo '<div class="notice notice-error"><p>Houzez Banner Search requires the Houzez theme.</p></div>';
    }
}
add_action('admin_notices', 'houzez_sas_admin_notice');

// Register shortcode directly as fallback (runs immediately when plugin loads)
function houzez_sas_register_shortcode_direct($atts = array(), $content = null) {
    // Ensure constants are defined
    if (!defined('HOUZEZ_SAS_PATH')) {
        return '<div class="houzez-sas-error"><p>Plugin not properly initialized. Please deactivate and reactivate.</p></div>';
    }
    
    // Load shortcode class if not loaded
    if (!class_exists('Houzez_Status_Area_Shortcode')) {
        $shortcode_file = HOUZEZ_SAS_PATH . 'includes/class-status-area-shortcode.php';
        if (file_exists($shortcode_file)) {
            require_once $shortcode_file;
        } else {
            return '<div class="houzez-sas-error"><p>Shortcode class file not found.</p></div>';
        }
    }
    
    // Use static method to render
    if (class_exists('Houzez_Status_Area_Shortcode')) {
        return Houzez_Status_Area_Shortcode::render_static($atts, $content);
    }
    
    return '<div class="houzez-sas-error"><p>Shortcode class could not be instantiated.</p></div>';
}
// Register immediately when plugin file is loaded
add_shortcode('houzez_banner_search', 'houzez_sas_register_shortcode_direct');
add_shortcode('houzez_status_area_search', 'houzez_sas_register_shortcode_direct');

// Load classes and register shortcode early (priority 5)
function houzez_sas_load_classes() {
    // Load plugin classes (don't check dependencies yet, do it later)
    require_once HOUZEZ_SAS_PATH . 'includes/class-status-area-search.php';
    require_once HOUZEZ_SAS_PATH . 'includes/class-status-area-ajax.php';
    require_once HOUZEZ_SAS_PATH . 'includes/class-status-area-shortcode.php';
    
    // Initialize AJAX handlers immediately (must be registered early)
    if (class_exists('Houzez_Status_Area_Ajax')) {
        new Houzez_Status_Area_Ajax();
    }
    
    // Initialize shortcode immediately (register shortcode early)
    if (class_exists('Houzez_Status_Area_Shortcode')) {
        new Houzez_Status_Area_Shortcode();
    }
}
// Load classes on plugins_loaded but before init
add_action('plugins_loaded', 'houzez_sas_load_classes', 5);

// Initialize plugin - Initialize other components
function houzez_sas_init() {
    // Check if Houzez theme is active
    if (!houzez_sas_check_theme()) {
        return;
    }
    
    // Initialize main class
    if (class_exists('Houzez_Status_Area_Search')) {
        Houzez_Status_Area_Search::init();
    }
    
    // AJAX handler is already initialized in houzez_sas_load_classes
    // No need to initialize again here
}

// Hook into plugins_loaded to ensure theme is loaded first
add_action('plugins_loaded', 'houzez_sas_init');

// Activation/Deactivation
function houzez_sas_activate() {
    if (!houzez_sas_check_theme()) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die('Houzez Banner Search requires the Houzez theme.', 'Plugin dependency missing', ['back_link' => true]);
    }
    flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'houzez_sas_activate');

function houzez_sas_deactivate() {
    flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'houzez_sas_deactivate');
