<?php
/**
 * Core loader for Status & Area search.
 */

if (!defined('ABSPATH')) {
    exit;
}

class Houzez_Status_Area_Search {

    public static function init() {
        add_action('wp_enqueue_scripts', [__CLASS__, 'enqueue_assets']);
    }

    /**
     * Register frontend assets (don't enqueue until shortcode is used).
     */
    public static function enqueue_assets() {
        // Enqueue Google Fonts - Open Sans
        wp_enqueue_style(
            'houzez-sas-google-fonts',
            'https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700&display=swap',
            [],
            null
        );

        wp_register_style(
            'houzez-sas',
            HOUZEZ_SAS_URL . 'assets/css/status-area-search.css',
            ['houzez-sas-google-fonts'],
            HOUZEZ_SAS_VERSION
        );

        wp_register_script(
            'houzez-sas',
            HOUZEZ_SAS_URL . 'assets/js/status-area-search.js',
            ['jquery'],
            HOUZEZ_SAS_VERSION,
            true
        );

        // Get search page URL
        $search_url = '';
        if (function_exists('houzez_get_search_template_link')) {
            $search_url = houzez_get_search_template_link();
        } else {
            // Fallback: try to find search template page
            $args = array(
                'meta_key' => '_wp_page_template',
                'meta_value' => 'template/template-search.php',
                'post_type' => 'page',
                'posts_per_page' => 1,
            );
            $pages = get_posts($args);
            if ($pages) {
                $search_url = get_permalink($pages[0]->ID);
            } else {
                $search_url = home_url('/');
            }
        }

        wp_localize_script(
            'houzez-sas',
            'houzezSAS',
            [
                'ajaxurl'         => admin_url('admin-ajax.php'),
                'nonce'           => wp_create_nonce('houzez_sas_nonce'),
                'searchUrl'       => $search_url,
                'minChars'        => 2,
                'noResults'       => esc_html__('No areas found', 'houzez-banner-search'),
                'loading'         => esc_html__('Loading...', 'houzez-banner-search'),
            ]
        );
    }

    /**
     * Enqueue assets (called from shortcode).
     */
    public static function enqueue() {
        // Make sure assets are registered first
        if (!wp_script_is('houzez-sas', 'registered')) {
            self::enqueue_assets();
        }
        
        // Get search page URL
        $search_url = '';
        if (function_exists('houzez_get_search_template_link')) {
            $search_url = houzez_get_search_template_link();
        } else {
            // Fallback: try to find search template page
            $args = array(
                'meta_key' => '_wp_page_template',
                'meta_value' => 'template/template-search.php',
                'post_type' => 'page',
                'posts_per_page' => 1,
            );
            $pages = get_posts($args);
            if ($pages) {
                $search_url = get_permalink($pages[0]->ID);
            } else {
                $search_url = home_url('/');
            }
        }

        // Re-localize script if needed (nonce might have changed)
        wp_localize_script(
            'houzez-sas',
            'houzezSAS',
            [
                'ajaxurl'         => admin_url('admin-ajax.php'),
                'nonce'           => wp_create_nonce('houzez_sas_nonce'),
                'searchUrl'       => $search_url,
                'minChars'        => 2,
                'noResults'       => esc_html__('No areas found', 'houzez-banner-search'),
                'loading'         => esc_html__('Loading...', 'houzez-banner-search'),
            ]
        );
        
        // Enqueue Google Fonts if not already enqueued
        if (!wp_style_is('houzez-sas-google-fonts', 'enqueued')) {
            wp_enqueue_style(
                'houzez-sas-google-fonts',
                'https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700&display=swap',
                [],
                null
            );
        }
        
        wp_enqueue_style('houzez-sas');
        wp_enqueue_script('houzez-sas');
    }
}
