<?php
/**
 * Shortcode registration.
 */

if (!defined('ABSPATH')) {
    exit;
}

class Houzez_Status_Area_Shortcode {
    
    private static $instance = null;

    public function __construct() {
        // Only register once
        if (self::$instance === null) {
            self::$instance = $this;
            // Register both shortcode names
            add_shortcode('houzez_banner_search', [__CLASS__, 'render_static']);
            add_shortcode('houzez_status_area_search', [__CLASS__, 'render_static']); // Legacy alias
            
            // Also register on init as fallback
            add_action('init', [__CLASS__, 'register_shortcodes'], 5);
        }
    }
    
    public static function register_shortcodes() {
        // Ensure shortcodes are registered (fallback)
        if (!shortcode_exists('houzez_banner_search')) {
            add_shortcode('houzez_banner_search', [__CLASS__, 'render_static']);
        }
        if (!shortcode_exists('houzez_status_area_search')) {
            add_shortcode('houzez_status_area_search', [__CLASS__, 'render_static']);
        }
    }
    
    public static function render_static($atts = array(), $content = null) {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance->render_shortcode($atts, $content);
    }

    public function render_shortcode($atts = array(), $content = null) {
        // Check if constants are defined
        if (!defined('HOUZEZ_SAS_PATH')) {
            return '<div class="houzez-sas-error"><p>Plugin constants not defined. Please deactivate and reactivate the plugin.</p></div>';
        }
        
        // Check if Houzez theme functions exist
        if (!function_exists('houzez_option')) {
            return '<div class="houzez-sas-error"><p>' . esc_html__('Houzez theme is required for this shortcode to work.', 'houzez-banner-search') . '</p></div>';
        }
        
        // Ensure we have an array
        if (!is_array($atts)) {
            $atts = array();
        }
        
        // Ensure assets are registered and enqueued
        if (!wp_style_is('houzez-sas', 'registered')) {
            if (class_exists('Houzez_Status_Area_Search')) {
                Houzez_Status_Area_Search::enqueue_assets();
            }
        }
        if (class_exists('Houzez_Status_Area_Search')) {
            Houzez_Status_Area_Search::enqueue();
        }

        $atts = shortcode_atts(
            [
                'status' => '',
                'area'   => '',
            ],
            $atts,
            'houzez_banner_search'
        );

        $selected_status = isset($_GET['status']) ? sanitize_text_field(wp_unslash($_GET['status'])) : $atts['status'];
        $selected_area   = isset($_GET['area']) ? sanitize_text_field(wp_unslash($_GET['area'])) : $atts['area'];

        $template_path = HOUZEZ_SAS_PATH . 'templates/search-interface.php';
        
        if (!file_exists($template_path)) {
            return '<div class="houzez-sas-error"><p>Error: Search interface template not found at: ' . esc_html($template_path) . '</p></div>';
        }

        ob_start();
        include $template_path;
        $output = ob_get_clean();
        
        if (empty($output)) {
            return '<div class="houzez-sas-error"><p>Error: Template returned empty output.</p></div>';
        }
        
        return $output;
    }
}
