<?php
/**
 * Frontend UI for status tabs + area autocomplete.
 *
 * @var string $selected_status
 * @var string $selected_area
 */

if (!defined('ABSPATH')) {
    exit;
}

$statuses = get_terms([
    'taxonomy'   => 'property_status',
    'hide_empty' => true,
    'exclude'    => [],
]);

// Build ordered list: Buy first, then Rent, then Offplan (and any others after)
$classified = [];
foreach ($statuses as $status) {
    $status_slug_lower = strtolower($status->slug);
    $status_name_lower = strtolower($status->name);
    $is_buy  = ($status_slug_lower === 'sell' || $status_name_lower === 'sell' || $status_slug_lower === 'for-sale' || $status_name_lower === 'for sale' || $status_slug_lower === 'buy' || $status_name_lower === 'buy');
    $is_rent = ($status_slug_lower === 'rent' || $status_name_lower === 'rent');
    $is_offplan = ($status_slug_lower === 'offplan' || $status_name_lower === 'offplan' || $status_slug_lower === 'off-plan' || $status_name_lower === 'off plan');
    if ($is_buy) {
        $classified[] = ['order' => 0, 'term' => $status];
    } elseif ($is_rent) {
        $classified[] = ['order' => 1, 'term' => $status];
    } elseif ($is_offplan) {
        $classified[] = ['order' => 2, 'term' => $status];
    } else {
        $classified[] = ['order' => 99, 'term' => $status];
    }
}
usort($classified, function ($a, $b) {
    return $a['order'] - $b['order'];
});
$statuses_ordered = array_column($classified, 'term');

// Ensure variables are set
if (!isset($selected_status)) {
    $selected_status = '';
}
if (!isset($selected_area)) {
    $selected_area = '';
}

$selected_status = $selected_status ? $selected_status : '';
$selected_area   = $selected_area ? $selected_area : '';
?>

<div class="houzez-sas" data-selected-status="<?php echo esc_attr($selected_status); ?>" data-selected-area="<?php echo esc_attr($selected_area); ?>">
    <div class="houzez-sas__container">
        <div class="houzez-sas__tabs" role="tablist">
            <?php 
            foreach ($statuses_ordered as $status) : 
                $status_slug_lower = strtolower($status->slug);
                $status_name_lower = strtolower($status->name);
                $is_buy  = ($status_slug_lower === 'sell' || $status_name_lower === 'sell' || $status_slug_lower === 'for-sale' || $status_name_lower === 'for sale' || $status_slug_lower === 'buy' || $status_name_lower === 'buy');
            ?>
                <button class="houzez-sas__tab<?php echo ($selected_status === $status->slug) ? ' is-active' : ''; ?>" data-status="<?php echo esc_attr($status->slug); ?>">
                    <?php 
                    $display_name = $status->name;
                    if ($is_buy) {
                        $display_name = 'Buy';
                    }
                    echo esc_html($display_name); 
                    ?>
                </button>
            <?php endforeach; ?>
        </div>

        <div class="houzez-sas__search">
            <div class="houzez-sas__input-wrap">
                <div class="houzez-sas__tags"></div>
                <input type="text" class="houzez-sas__area-input" placeholder="<?php esc_attr_e('Area or Community', 'houzez-banner-search'); ?>" value="">
                <div class="houzez-sas__suggestions" hidden></div>
            </div>
        </div>

        <button type="button" class="houzez-sas__search-btn">
            <?php esc_html_e('Search', 'houzez-banner-search'); ?>
        </button>
    </div>
</div>
