# Media Bulk Download

[![WordPress](https://img.shields.io/badge/WordPress-5.0%2B-blue.svg)](https://wordpress.org/)
[![PHP](https://img.shields.io/badge/PHP-7.4%2B-purple.svg)](https://php.net/)
[![License](https://img.shields.io/badge/License-GPL%20v2%2B-green.svg)](https://www.gnu.org/licenses/gpl-2.0.html)

**Professional WordPress plugin that adds powerful bulk download functionality to the Media Library.**

## 🚀 Features

- **Smart Download Options**: Download selected media files or entire media library
- **Seamless Integration**: Works perfectly with existing WordPress Media Library interface
- **Intelligent Button Management**: Smart visibility based on current mode (bulk select vs normal)
- **Universal File Support**: Supports all media types (images, videos, audio, documents, PDFs)
- **Professional ZIP Creation**: Creates optimized ZIP archives with unique filename handling
- **Advanced Security**: Comprehensive nonce verification and capability checks
- **Automatic Cleanup**: Temporary files are automatically removed after download
- **Memory Efficient**: Handles large media libraries without performance issues

## 📋 Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- ZipArchive PHP extension

## 🛠️ Installation

1. Upload the plugin files to `/wp-content/plugins/media-bulk-download/`
2. Activate the plugin through the 'Plugins' screen in WordPress
3. The plugin automatically integrates with your Media Library - no configuration needed!

## 📖 Usage

### Download Selected Files
1. Go to **Media > Library** in your WordPress admin
2. Click **"Bulk Select"**
3. Select the media files you want to download
4. Click **"Download Selected"**
5. Your files will be downloaded as a ZIP archive

### Download All Media
1. Go to **Media > Library** in your WordPress admin
2. Click **"Download All Media"** button
3. Your entire media library will be downloaded as a ZIP archive

## 🔒 Security Features

- WordPress nonce verification for all requests
- Capability checks (users need 'upload_files' or 'delete_posts' capability)
- File validation before adding to ZIP archives
- Automatic cleanup of temporary files
- Prevention of direct file access

## 🎯 Professional Benefits

- **Time Saving**: Download hundreds of files with a single click
- **Backup Solution**: Create complete media library backups instantly
- **Client Delivery**: Easily package and deliver media files to clients
- **Site Migration**: Export all media files for site transfers
- **File Organization**: Maintain original filenames and folder structure

## 🆘 Support

### Professional Support
- **Website**: [www.devmizan.com](https://www.devmizan.com)
- **Email**: support@devmizan.com
- **Documentation**: [www.devmizan.com/media-bulk-download-docs](https://www.devmizan.com/media-bulk-download-docs)

### Free Support
- WordPress.org Support Forums
- GitHub Issues (for bug reports)

## 👨‍💻 Developer

**Dev Mizan** - Professional WordPress Developer
- Website: [www.devmizan.com](https://www.devmizan.com)
- Email: contact@devmizan.com
- Portfolio: [www.devmizan.com/portfolio](https://www.devmizan.com/portfolio)

## 📄 License

This plugin is licensed under the GPL v2 or later.

```
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
```

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## 📝 Changelog

See [CHANGELOG.md](CHANGELOG.md) for a list of changes.

---

**Made with ❤️ by [Dev Mizan](https://www.devmizan.com)**
