<?php
/**
 * Pixxi Forms Field Mapping Page
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get all forms
$forms = Pixxi_Forms_Settings::get_all_forms();
$selected_form_id = isset($_GET['form']) ? absint($_GET['form']) : 0;
$selected_form = null;
$field_mappings = array();

if ($selected_form_id > 0) {
    $selected_form = Pixxi_Forms_Settings::get_form_by_id($selected_form_id);
    if ($selected_form && isset($selected_form['field_mappings']) && is_array($selected_form['field_mappings'])) {
        $field_mappings = $selected_form['field_mappings'];
    }
}

// Handle save
if (isset($_POST['save_field_mapping']) && check_admin_referer('pixxi_field_mapping_nonce')) {
    $form_id = isset($_POST['form_id']) ? absint($_POST['form_id']) : 0;
    $raw_mappings = isset($_POST['field_mappings']) && is_array($_POST['field_mappings']) ? $_POST['field_mappings'] : array();
    $field_mappings = array();
    foreach ($raw_mappings as $row) {
        $field_mappings[] = array(
            'field_name'  => isset($row['field_name']) ? sanitize_text_field(wp_unslash($row['field_name'])) : '',
            'field_label' => isset($row['field_label']) ? sanitize_text_field(wp_unslash($row['field_label'])) : '',
            'field_type'  => isset($row['field_type']) ? sanitize_key(wp_unslash($row['field_type'])) : 'text',
            'required'    => !empty($row['required']),
        );
    }

    if ($form_id > 0) {
        global $wpdb;
        $table = $wpdb->prefix . 'pixxi_forms';
        $wpdb->update(
            $table,
            array('field_mappings' => wp_json_encode($field_mappings)),
            array('id' => $form_id),
            array('%s'),
            array('%d')
        );
        echo '<div class="pixxi-notice pixxi-notice-success">' . esc_html__('Field mappings saved successfully!', 'pixxi-forms') . '</div>';
        $selected_form = Pixxi_Forms_Settings::get_form_by_id($form_id);
    }
}
?>

<div class="pixxi-admin-wrapper">
    <div class="pixxi-admin-header">
        <h1>Field Mapping</h1>
        <p class="pixxi-subtitle">Configure custom fields for your forms</p>
    </div>

    <div class="pixxi-admin-content">
        <?php if (empty($forms)): ?>
            <div class="pixxi-card">
                <div class="pixxi-card-body">
                    <div class="pixxi-empty-state">
                        <svg class="pixxi-empty-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <h3>No forms available</h3>
                        <p>Create a form first to configure field mappings</p>
                        <a href="<?php echo esc_url(admin_url('admin.php?page=pixxi-forms-manage')); ?>" class="pixxi-btn pixxi-btn-primary">
                            Create Form
                        </a>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="pixxi-card">
                <div class="pixxi-card-body">
                    <div class="pixxi-form-group">
                        <label for="form-select" class="pixxi-label">Select Form</label>
                        <select id="form-select" class="pixxi-input-large" onchange="window.location.href='<?php echo esc_url(admin_url('admin.php?page=pixxi-forms-field-mapping&form=')); ?>' + encodeURIComponent(this.value)">
                            <option value="">-- Select a form --</option>
                            <?php foreach ($forms as $form): ?>
                                <option value="<?php echo esc_attr((string) $form['id']); ?>" <?php selected($selected_form_id, (int) $form['id']); ?>>
                                    <?php echo esc_html($form['form_name']); ?> (<?php echo esc_html(ucfirst($form['form_type'])); ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>

            <?php if ($selected_form): ?>
                <div class="pixxi-card">
                    <div class="pixxi-card-header">
                        <h2><?php echo esc_html($selected_form['form_name']); ?> - Field Configuration</h2>
                    </div>
                    <div class="pixxi-card-body">
                        <div class="pixxi-info-box">
                            <strong>Standard Fields (Always Available):</strong>
                            <ul>
                                <li>Name</li>
                                <li>Email (Required)</li>
                                <li>Phone</li>
                                <?php if ($selected_form['form_type'] === 'listing'): ?>
                                    <li>Property ID (Required for listing forms)</li>
                                <?php endif; ?>
                            </ul>
                        </div>

                        <h3>Custom Fields (Extra Data)</h3>
                        <p>Add custom fields that will be sent as extraData to Pixxi CRM</p>

                        <form method="post" id="field-mapping-form">
                            <?php wp_nonce_field('pixxi_field_mapping_nonce'); ?>
                            <input type="hidden" name="form_id" value="<?php echo esc_attr((string) $selected_form['id']); ?>">
                            <input type="hidden" name="save_field_mapping" value="1">

                            <div id="custom-fields-container">
                                <?php
                                if (empty($field_mappings)): 
                                ?>
                                    <div class="pixxi-empty-fields">
                                        <p>No custom fields added yet. Click "Add Field" to create one.</p>
                                    </div>
                                <?php else: ?>
                                    <?php foreach ($field_mappings as $index => $field): ?>
                                        <div class="pixxi-field-row">
                                            <div class="pixxi-field-group">
                                                <label>Field Name</label>
                                                <input 
                                                    type="text" 
                                                    name="field_mappings[<?php echo $index; ?>][field_name]" 
                                                    class="pixxi-input"
                                                    value="<?php echo esc_attr($field['field_name']); ?>"
                                                    placeholder="e.g., message"
                                                >
                                            </div>
                                            <div class="pixxi-field-group">
                                                <label>Field Label</label>
                                                <input 
                                                    type="text" 
                                                    name="field_mappings[<?php echo $index; ?>][field_label]" 
                                                    class="pixxi-input"
                                                    value="<?php echo esc_attr($field['field_label']); ?>"
                                                    placeholder="e.g., Message"
                                                >
                                            </div>
                                            <div class="pixxi-field-group">
                                                <label>Field Type</label>
                                                <select name="field_mappings[<?php echo $index; ?>][field_type]" class="pixxi-input">
                                                    <option value="text" <?php selected($field['field_type'], 'text'); ?>>Text</option>
                                                    <option value="email" <?php selected($field['field_type'], 'email'); ?>>Email</option>
                                                    <option value="tel" <?php selected($field['field_type'], 'tel'); ?>>Phone</option>
                                                    <option value="number" <?php selected($field['field_type'], 'number'); ?>>Number</option>
                                                    <option value="textarea" <?php selected($field['field_type'], 'textarea'); ?>>Textarea</option>
                                                </select>
                                            </div>
                                            <div class="pixxi-field-group-checkbox">
                                                <label>
                                                    <input 
                                                        type="checkbox" 
                                                        name="field_mappings[<?php echo $index; ?>][required]" 
                                                        value="1"
                                                        <?php checked(isset($field['required']) && $field['required']); ?>
                                                    >
                                                    Required
                                                </label>
                                            </div>
                                            <div class="pixxi-field-actions">
                                                <button type="button" class="pixxi-btn-icon remove-field" title="Remove">
                                                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" width="18" height="18">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                    </svg>
                                                </button>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>

                            <div class="pixxi-form-actions" style="margin-top: 24px;">
                                <button type="button" id="add-field-btn" class="pixxi-btn pixxi-btn-secondary">
                                    + Add Field
                                </button>
                                <button type="submit" class="pixxi-btn pixxi-btn-primary">
                                    Save Field Mappings
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    var fieldIndex = <?php echo count($field_mappings); ?>;

    // Add new field
    $('#add-field-btn').on('click', function() {
        $('.pixxi-empty-fields').remove();
        
        var fieldHtml = `
            <div class="pixxi-field-row">
                <div class="pixxi-field-group">
                    <label>Field Name</label>
                    <input 
                        type="text" 
                        name="field_mappings[${fieldIndex}][field_name]" 
                        class="pixxi-input"
                        placeholder="e.g., message"
                    >
                </div>
                <div class="pixxi-field-group">
                    <label>Field Label</label>
                    <input 
                        type="text" 
                        name="field_mappings[${fieldIndex}][field_label]" 
                        class="pixxi-input"
                        placeholder="e.g., Message"
                    >
                </div>
                <div class="pixxi-field-group">
                    <label>Field Type</label>
                    <select name="field_mappings[${fieldIndex}][field_type]" class="pixxi-input">
                        <option value="text">Text</option>
                        <option value="email">Email</option>
                        <option value="tel">Phone</option>
                        <option value="number">Number</option>
                        <option value="textarea">Textarea</option>
                    </select>
                </div>
                <div class="pixxi-field-group-checkbox">
                    <label>
                        <input 
                            type="checkbox" 
                            name="field_mappings[${fieldIndex}][required]" 
                            value="1"
                        >
                        Required
                    </label>
                </div>
                <div class="pixxi-field-actions">
                    <button type="button" class="pixxi-btn-icon remove-field" title="Remove">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" width="18" height="18">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                        </svg>
                    </button>
                </div>
            </div>
        `;
        
        $('#custom-fields-container').append(fieldHtml);
        fieldIndex++;
    });

    // Remove field
    $(document).on('click', '.remove-field', function() {
        $(this).closest('.pixxi-field-row').remove();
        
        if ($('.pixxi-field-row').length === 0) {
            $('#custom-fields-container').html('<div class="pixxi-empty-fields"><p>No custom fields added yet. Click "Add Field" to create one.</p></div>');
        }
    });
});
</script>

