<?php
/**
 * Pixxi Forms Management Page
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get all forms
$forms = Pixxi_Forms_Settings::get_all_forms();
$pages_for_redirect = get_pages(array('sort_column' => 'post_title', 'post_status' => 'publish'));
?>

<div class="pixxi-admin-wrapper">
    <div class="pixxi-admin-header">
        <h1>Manage Forms</h1>
        <div class="pixxi-header-actions">
            <button type="button" id="add-form-btn" class="pixxi-btn pixxi-btn-primary">
                + Add New Form
            </button>
        </div>
    </div>

    <div class="pixxi-admin-content">
        <div class="pixxi-card">
            <div class="pixxi-card-body">
                <?php if (empty($forms)): ?>
                    <div class="pixxi-empty-state">
                        <svg class="pixxi-empty-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <h3>No forms yet</h3>
                        <p>Create your first form to start collecting leads</p>
                        <button type="button" class="pixxi-btn pixxi-btn-primary" onclick="document.getElementById('add-form-btn').click()">
                            Create Your First Form
                        </button>
                    </div>
                <?php else: ?>
                    <div class="pixxi-table-wrapper">
                        <table class="pixxi-table">
                            <thead>
                                <tr>
                                    <th>Form Name</th>
                                    <th>Form ID</th>
                                    <th>Type</th>
                                    <th>Shortcode</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($forms as $form): ?>
                                <tr>
                                    <td><strong><?php echo esc_html($form['form_name']); ?></strong></td>
                                    <td><code><?php echo esc_html($form['form_id']); ?></code></td>
                                    <td>
                                        <span class="pixxi-badge pixxi-badge-<?php echo esc_attr($form['form_type'] === 'listing' ? 'primary' : 'secondary'); ?>">
                                            <?php echo esc_html(ucfirst($form['form_type'])); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="pixxi-shortcode-display">
                                            <code class="pixxi-shortcode" style="font-size: 11px;"><?php 
                                                if ($form['form_type'] === 'listing') {
                                                    echo '[pixxi_listing_form form_id="' . esc_attr($form['form_id']) . '" property_id="YOUR_PROPERTY_ID"]';
                                                } else {
                                                    echo '[pixxi_general_form form_id="' . esc_attr($form['form_id']) . '"]';
                                                }
                                            ?></code><br>
                                            <small style="color: #666; font-size: 11px;">Add show_labels="no" to hide labels</small>
                                            <button 
                                                type="button" 
                                                class="pixxi-btn-icon copy-shortcode" 
                                                data-shortcode="<?php 
                                                    if ($form['form_type'] === 'listing') {
                                                        echo esc_attr('[pixxi_listing_form form_id="' . $form['form_id'] . '" property_id="YOUR_PROPERTY_ID"]');
                                                    } else {
                                                        echo esc_attr('[pixxi_general_form form_id="' . $form['form_id'] . '"]');
                                                    }
                                                ?>"
                                                title="Copy shortcode"
                                            >
                                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" width="16" height="16">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                                </svg>
                                            </button>
                                        </div>
                                    </td>
                                    <td><?php echo esc_html(date('M d, Y', strtotime($form['created_at']))); ?></td>
                                    <td>
                                        <div class="pixxi-actions">
                                            <button 
                                                type="button" 
                                                class="pixxi-btn-icon edit-form" 
                                                data-id="<?php echo esc_attr((string) $form['id']); ?>"
                                                title="<?php esc_attr_e('Edit', 'pixxi-forms'); ?>"
                                            >
                                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" width="18" height="18">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                                </svg>
                                            </button>
                                            <button 
                                                type="button" 
                                                class="pixxi-btn-icon delete-form" 
                                                data-id="<?php echo esc_attr((string) $form['id']); ?>"
                                                data-name="<?php echo esc_attr($form['form_name']); ?>"
                                                title="<?php esc_attr_e('Delete', 'pixxi-forms'); ?>"
                                            >
                                                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24" width="18" height="18">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                </svg>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Add/Edit Form Modal -->
<div id="form-modal" class="pixxi-modal" style="display: none;">
    <div class="pixxi-modal-overlay"></div>
    <div class="pixxi-modal-content">
        <div class="pixxi-modal-header">
            <h2 id="modal-title">Add New Form</h2>
            <button type="button" class="pixxi-modal-close">&times;</button>
        </div>
        <div class="pixxi-modal-body">
            <form id="form-editor">
                <input type="hidden" id="form-edit-id" value="">
                
                <div class="pixxi-form-group">
                    <label for="form-name" class="pixxi-label">
                        Form Name <span class="required">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="form-name" 
                        class="pixxi-input-large"
                        placeholder="e.g., Property Inquiry Form"
                        required
                    >
                </div>

                <div class="pixxi-form-group">
                    <label for="form-id" class="pixxi-label">
                        Pixxi CRM Form ID <span class="required">*</span>
                    </label>
                    <input 
                        type="text" 
                        id="form-id" 
                        class="pixxi-input-large"
                        placeholder="e.g., c08b42f7-9ebb-4247-b339-3d006ef0f073"
                        required
                    >
                    <p class="pixxi-help-text">Get this from your Pixxi CRM form configuration</p>
                </div>

                <div class="pixxi-form-group">
                    <label for="form-type" class="pixxi-label">
                        Form Type <span class="required">*</span>
                    </label>
                    <select id="form-type" class="pixxi-input-large" required>
                        <option value="general">General Form</option>
                        <option value="listing">Listing Form</option>
                    </select>
                    <p class="pixxi-help-text">
                        <strong>Listing:</strong> For property-specific forms (requires property_id)<br>
                        <strong>General:</strong> For general inquiries (property_id optional)
                    </p>
                </div>

                <?php do_action('pixxi_forms_form_editor_after_form_type'); ?>

                <div class="pixxi-form-group pixxi-success-behavior">
                    <label class="pixxi-label"><?php esc_html_e('Success behavior', 'pixxi-forms'); ?></label>
                    <p class="pixxi-help-text" style="margin-bottom: 12px;"><?php esc_html_e('After successful submission: show a message or redirect to a page.', 'pixxi-forms'); ?></p>
                    <div class="pixxi-form-group">
                        <label class="pixxi-label-inline">
                            <input type="radio" name="success_type" value="message" id="success-type-message" checked>
                            <?php esc_html_e('Show thank-you message', 'pixxi-forms'); ?>
                        </label>
                        <label class="pixxi-label-inline">
                            <input type="radio" name="success_type" value="redirect" id="success-type-redirect">
                            <?php esc_html_e('Redirect to page or URL', 'pixxi-forms'); ?>
                        </label>
                    </div>
                    <div id="success-message-wrap" class="pixxi-form-group">
                        <label for="form-success-message" class="pixxi-label"><?php esc_html_e('Thank-you message', 'pixxi-forms'); ?></label>
                        <textarea id="form-success-message" name="success_message" class="pixxi-input-large pixxi-textarea" rows="3" placeholder="<?php esc_attr_e('Thank you! We have received your message.', 'pixxi-forms'); ?>"></textarea>
                    </div>
                    <div id="success-redirect-wrap" class="pixxi-form-group" style="display: none;">
                        <label for="form-redirect-page" class="pixxi-label"><?php esc_html_e('Redirect to page', 'pixxi-forms'); ?></label>
                        <select id="form-redirect-page" name="redirect_page_id" class="pixxi-input-large">
                            <option value=""><?php esc_html_e('— Select a page —', 'pixxi-forms'); ?></option>
                            <?php foreach ($pages_for_redirect as $page): ?>
                                <option value="<?php echo esc_attr((string) $page->ID); ?>"><?php echo esc_html($page->post_title); ?></option>
                            <?php endforeach; ?>
                        </select>
                        <p class="pixxi-help-text"><?php esc_html_e('Or enter a custom URL below (overrides page if set).', 'pixxi-forms'); ?></p>
                        <label for="form-redirect-url" class="pixxi-label" style="margin-top: 12px;"><?php esc_html_e('Or redirect URL', 'pixxi-forms'); ?></label>
                        <input type="url" id="form-redirect-url" name="redirect_url" class="pixxi-input-large" placeholder="https://">
                    </div>
                </div>
            </form>
        </div>
        <div class="pixxi-modal-footer">
            <button type="button" class="pixxi-btn pixxi-btn-secondary pixxi-modal-close">Cancel</button>
            <button type="button" id="save-form-btn" class="pixxi-btn pixxi-btn-primary">Save Form</button>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    var modal = $('#form-modal');
    var isEdit = false;

    // Success behavior toggle
    $('input[name="success_type"]').on('change', function() {
        var val = $(this).val();
        $('#success-message-wrap').toggle(val === 'message');
        $('#success-redirect-wrap').toggle(val === 'redirect');
    });

    // Open modal for new form
    $('#add-form-btn').on('click', function() {
        isEdit = false;
        $('#modal-title').text('Add New Form');
        $('#form-edit-id').val('');
        $('#form-editor')[0].reset();
        $('#success-type-message').prop('checked', true);
        $('#success-message-wrap').show();
        $('#success-redirect-wrap').hide();
        modal.fadeIn(200);
    });

    // Open modal for edit
    $(document).on('click', '.edit-form', function() {
        isEdit = true;
        var formId = $(this).data('id');
        $('#modal-title').text('Edit Form');
        
        // Load form data
        $.ajax({
            url: pixxiForms.ajax_url,
            method: 'POST',
            data: {
                action: 'pixxi_get_form',
                nonce: pixxiForms.nonce,
                id: formId
            },
            success: function(response) {
                if (response.success) {
                    var form = response.data;
                    var settings = form.settings || {};
                    $('#form-edit-id').val(form.id);
                    $('#form-name').val(form.form_name);
                    $('#form-id').val(form.form_id);
                    $('#form-type').val(form.form_type);
                    var successType = (settings.success_type || 'message').toString();
                    $('input[name="success_type"][value="' + successType + '"]').prop('checked', true);
                    $('#form-success-message').val(settings.success_message || '');
                    $('#form-redirect-page').val(settings.redirect_page_id || '');
                    $('#form-redirect-url').val(settings.redirect_url || '');
                    if ($('#form-api-profile-id').length) {
                        $('#form-api-profile-id').val(settings.api_profile_id || '');
                    }
                    $('#success-message-wrap').toggle(successType === 'message');
                    $('#success-redirect-wrap').toggle(successType === 'redirect');
                    modal.fadeIn(200);
                }
            }
        });
    });

    // Close modal
    $('.pixxi-modal-close, .pixxi-modal-overlay').on('click', function() {
        modal.fadeOut(200);
    });

    // Save form
    $('#save-form-btn').on('click', function() {
        var btn = $(this);
        var originalText = btn.text();
        var successType = $('input[name="success_type"]:checked').val() || 'message';
        var formData = {
            action: 'pixxi_save_form',
            nonce: pixxiForms.nonce,
            id: $('#form-edit-id').val(),
            form_name: $('#form-name').val(),
            form_id: $('#form-id').val(),
            form_type: $('#form-type').val(),
            'settings[success_type]': successType,
            'settings[success_message]': $('#form-success-message').val(),
            'settings[redirect_page_id]': $('#form-redirect-page').val(),
            'settings[redirect_url]': $('#form-redirect-url').val(),
            'settings[api_profile_id]': ($('#form-api-profile-id').length ? $('#form-api-profile-id').val() : '')
        };

        if (!formData.form_name || !formData.form_id) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please fill in all required fields',
                confirmButtonColor: '#000000'
            });
            return;
        }

        btn.prop('disabled', true).text('Saving...');

        $.ajax({
            url: pixxiForms.ajax_url,
            method: 'POST',
            data: formData,
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: response.data.message,
                        confirmButtonColor: '#000000'
                    }).then(function() {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.data.message,
                        confirmButtonColor: '#000000'
                    });
                }
            },
            complete: function() {
                btn.prop('disabled', false).text(originalText);
            }
        });
    });

    // Delete form
    $(document).on('click', '.delete-form', function() {
        var formId = $(this).data('id');
        var formName = $(this).data('name');

        Swal.fire({
            title: 'Delete Form?',
            text: 'Are you sure you want to delete "' + formName + '"? This action cannot be undone.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#000000',
            cancelButtonColor: '#666666',
            confirmButtonText: 'Yes, delete it'
        }).then(function(result) {
            if (result.isConfirmed) {
                $.ajax({
                    url: pixxiForms.ajax_url,
                    method: 'POST',
                    data: {
                        action: 'pixxi_delete_form',
                        nonce: pixxiForms.nonce,
                        id: formId
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted',
                                text: response.data.message,
                                confirmButtonColor: '#000000'
                            }).then(function() {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.data.message,
                                confirmButtonColor: '#000000'
                            });
                        }
                    }
                });
            }
        });
    });

    // Copy shortcode
    $(document).on('click', '.copy-shortcode', function() {
        var shortcode = $(this).data('shortcode');
        var temp = $('<input>');
        $('body').append(temp);
        temp.val(shortcode).select();
        document.execCommand('copy');
        temp.remove();

        Swal.fire({
            icon: 'success',
            title: 'Copied!',
            text: 'Shortcode copied to clipboard',
            timer: 1500,
            showConfirmButton: false
        });
    });
});
</script>

