<?php
/**
 * Pixxi Forms – Pro Features (icon box grid).
 */

if (!defined('ABSPATH')) {
    exit;
}

$upgrade_url = 'https://devmizan.com/plugins/pixxi-forms/';

$pro_features = array(
    array(
        'title'   => 'Submission Logs',
        'desc'    => 'View and export all form submissions in one place. Search, filter, and download entries for your records or CRM.',
        'icon'    => 'dashicons-clipboard',
        'dashicon_aria' => 'Clipboard',
    ),
    array(
        'title'   => 'Country Code Selector',
        'desc'    => 'Phone field with country flags and dial codes. Let visitors pick their country for a better form experience.',
        'icon'    => 'dashicons-phone',
        'dashicon_aria' => 'Phone',
    ),
    array(
        'title'   => 'Email Notifications',
        'desc'    => 'Send automatic email alerts when a form is submitted. Notify admins and optionally the submitter.',
        'icon'    => 'dashicons-email-alt',
        'dashicon_aria' => 'Email',
    ),
    array(
        'title'   => 'reCAPTCHA & Spam Protection',
        'desc'    => 'Integrate Google reCAPTCHA v2 to block bots and reduce spam submissions on your forms.',
        'icon'    => 'dashicons-shield',
        'dashicon_aria' => 'Shield',
    ),
    array(
        'title'   => 'Thank-You Message & Redirect',
        'desc'    => 'Show a custom thank-you message or redirect users to a page after successful submission.',
        'icon'    => 'dashicons-yes-alt',
        'dashicon_aria' => 'Check',
    ),
    array(
        'title'   => 'Webhooks',
        'desc'    => 'Send form data to external URLs in real time. Connect to Zapier, Make, or your own endpoints.',
        'icon'    => 'dashicons-admin-links',
        'dashicon_aria' => 'Webhook',
    ),
    array(
        'title'   => 'Multiple API Profiles',
        'desc'    => 'Use different API credentials per form or environment. Ideal for staging and multi-tenant setups.',
        'icon'    => 'dashicons-rest-api',
        'dashicon_aria' => 'API',
    ),
    array(
        'title'   => 'Advanced Field Mapping',
        'desc'    => 'Map form fields to your CRM or API with full control over labels, required rules, and custom fields.',
        'icon'    => 'dashicons-editor-table',
        'dashicon_aria' => 'Table',
    ),
);
?>

<div class="pixxi-admin-wrapper pixxi-pro-features-page">
    <div class="pixxi-admin-header">
        <div>
            <h1>Pro Features</h1>
            <p class="pixxi-subtitle">
                Get submission logs, country code selector in the phone field, email notifications, and more.
            </p>
        </div>
        <div class="pixxi-header-actions">
            <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" rel="noopener" class="pixxi-btn pixxi-btn-primary pixxi-btn-pro">
                Upgrade to Pro
            </a>
        </div>
    </div>

    <div class="pixxi-admin-content">
        <div class="pixxi-pro-features-grid">
            <?php foreach ($pro_features as $feature) : ?>
                <div class="pixxi-pro-feature-box">
                    <div class="pixxi-pro-feature-icon" aria-hidden="true">
                        <span class="dashicons <?php echo esc_attr($feature['icon']); ?>" aria-label="<?php echo esc_attr($feature['dashicon_aria']); ?>"></span>
                    </div>
                    <h3 class="pixxi-pro-feature-title"><?php echo esc_html($feature['title']); ?></h3>
                    <p class="pixxi-pro-feature-desc"><?php echo esc_html($feature['desc']); ?></p>
                    <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" rel="noopener" class="pixxi-btn pixxi-btn-secondary pixxi-pro-feature-btn">
                        Learn more
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
