<?php
/**
 * Pixxi Forms Settings Page
 */

if (!defined('ABSPATH')) {
    exit;
}

// Handle form submission
if (isset($_POST['pixxi_forms_save_settings']) && check_admin_referer('pixxi_forms_settings_nonce')) {
    $api_token = isset($_POST['api_token']) ? sanitize_text_field(wp_unslash($_POST['api_token'])) : '';
    $api_url = isset($_POST['api_url']) ? esc_url_raw(wp_unslash($_POST['api_url'])) : '';

    update_option('pixxi_forms_api_token', $api_token);
    update_option('pixxi_forms_api_url', $api_url);

    $remove_data = isset($_POST['remove_data_on_uninstall']) && $_POST['remove_data_on_uninstall'] === '1';
    update_option('pixxi_forms_remove_data_on_uninstall', $remove_data);

    if (function_exists('pixxi_forms_is_pro_active') && pixxi_forms_is_pro_active()) {
        $default_phone_country = isset($_POST['default_phone_country']) ? sanitize_text_field(wp_unslash($_POST['default_phone_country'])) : 'ae';
        update_option(Pixxi_Forms_Settings::DEFAULT_PHONE_COUNTRY_OPTION, $default_phone_country);
        $phone_show_country_code = isset($_POST['phone_show_country_code']) && $_POST['phone_show_country_code'] === '1';
        update_option(Pixxi_Forms_Settings::PHONE_SHOW_COUNTRY_CODE_OPTION, $phone_show_country_code);
    }

    do_action('pixxi_forms_after_save_settings', $_POST);
    echo '<div class="pixxi-notice pixxi-notice-success">' . esc_html__('Settings saved successfully!', 'pixxi-forms') . '</div>';
}

$api_token = get_option('pixxi_forms_api_token', '');
$api_url = get_option('pixxi_forms_api_url', 'https://dataapi.pixxicrm.ae/pixxiapi/webhook/v1/form');
$default_phone_country = get_option(Pixxi_Forms_Settings::DEFAULT_PHONE_COUNTRY_OPTION, '');
$phone_show_country_code = get_option(Pixxi_Forms_Settings::PHONE_SHOW_COUNTRY_CODE_OPTION, true);
$remove_data_on_uninstall = get_option('pixxi_forms_remove_data_on_uninstall', false);
$phone_countries = Pixxi_Forms_Settings::get_phone_countries();
$is_pro = function_exists('pixxi_forms_is_pro_active') && pixxi_forms_is_pro_active();
?>

<div class="pixxi-admin-wrapper">
    <div class="pixxi-admin-header">
        <h1>Pixxi Forms Settings</h1>
        <p class="pixxi-subtitle">Configure your Pixxi CRM API connection</p>
    </div>

    <div class="pixxi-admin-content">
        <form method="post" action="" id="pixxi-settings-form">
            <?php wp_nonce_field('pixxi_forms_settings_nonce'); ?>
            <div class="pixxi-settings-row">
                <div class="pixxi-settings-col pixxi-settings-col-main">
                    <div class="pixxi-card">
                        <div class="pixxi-card-header">
                            <h2>API Configuration</h2>
                        </div>
                        <div class="pixxi-card-body">
                            <div class="pixxi-form-group">
                                <label for="api_token" class="pixxi-label">
                                    API Token <span class="required">*</span>
                                </label>
                                <input 
                                    type="text" 
                                    id="api_token" 
                                    name="api_token" 
                                    class="pixxi-input-large"
                                    value="<?php echo esc_attr($api_token); ?>"
                                    placeholder="Enter your Pixxi CRM API token"
                                    required
                                >
                                <p class="pixxi-help-text">
                                    Get your API token from: Pixxi CRM → Admin → Integrations → Pixxi Forms
                                </p>
                            </div>

                            <div class="pixxi-form-group">
                                <label for="api_url" class="pixxi-label">
                                    API Endpoint URL <span class="required">*</span>
                                </label>
                                <input 
                                    type="url" 
                                    id="api_url" 
                                    name="api_url" 
                                    class="pixxi-input-large"
                                    value="<?php echo esc_attr($api_url); ?>"
                                    placeholder="https://dataapi.pixxicrm.ae/pixxiapi/webhook/v1/form"
                                    required
                                >
                                <p class="pixxi-help-text">
                                    Default: https://dataapi.pixxicrm.ae/pixxiapi/webhook/v1/form
                                </p>
                            </div>

                            <div class="pixxi-form-group">
                                <label class="pixxi-label">
                                    <input type="checkbox" name="remove_data_on_uninstall" value="1" <?php checked($remove_data_on_uninstall); ?>>
                                    <?php esc_html_e('Remove all plugin data (options and tables) when the plugin is deleted', 'pixxi-forms'); ?>
                                </label>
                                <p class="pixxi-help-text"><?php esc_html_e('If unchecked, your forms and submissions data will remain in the database after uninstall.', 'pixxi-forms'); ?></p>
                            </div>
                        </div>
                    </div>

                    <?php do_action('pixxi_forms_settings_after_api_card'); ?>

                    <div class="pixxi-card pixxi-card-pro <?php echo $is_pro ? '' : 'pixxi-card--locked'; ?>">
                        <div class="pixxi-card-header pixxi-card-header-pro">
                            <h2>Pro Features <span class="pixxi-badge pixxi-badge-pro">Pro</span><?php if ( ! $is_pro ) : ?> <span class="pixxi-badge pixxi-badge-locked">Locked</span><?php endif; ?></h2>
                        </div>
                        <div class="pixxi-card-body">
                            <?php if ($is_pro) : ?>
                                <div class="pixxi-form-group">
                                    <div class="pixxi-toggle-wrap">
                                        <label class="pixxi-toggle" for="phone_show_country_code" aria-hidden="true">
                                            <input type="checkbox" id="phone_show_country_code" name="phone_show_country_code" value="1" <?php checked($phone_show_country_code); ?>>
                                            <span class="pixxi-toggle-slider"></span>
                                        </label>
                                        <span class="pixxi-toggle-label-text"><?php esc_html_e('Enable country code selector on phone field', 'pixxi-forms'); ?> <span class="pixxi-badge pixxi-badge-pro">Pro</span></span>
                                    </div>
                                    <p class="pixxi-help-text"><?php esc_html_e('When enabled, forms show country + dial code selector; when disabled, a plain phone input is shown.', 'pixxi-forms'); ?></p>
                                </div>
                                <div class="pixxi-form-group pixxi-depends" data-pixxi-depends="phone_show_country_code"<?php echo $phone_show_country_code ? '' : ' style="display:none;"'; ?>>
                                    <label for="default_phone_country" class="pixxi-label">
                                        Default phone country <span class="pixxi-badge pixxi-badge-pro">Pro</span>
                                    </label>
                                    <select 
                                        id="default_phone_country" 
                                        name="default_phone_country" 
                                        class="pixxi-input"
                                        style="max-width: 320px;"
                                        <?php echo $phone_show_country_code ? '' : ' disabled'; ?>
                                    >
                                        <option value="" <?php selected($default_phone_country, ''); ?>>Select country</option>
                                        <?php foreach ($phone_countries as $iso2 => $data) : ?>
                                            <option value="<?php echo esc_attr($iso2); ?>" <?php selected($default_phone_country, $iso2); ?>>
                                                <?php echo esc_html($data['name'] . ' (' . $data['dialCode'] . ')'); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <p class="pixxi-help-text">
                                        Default country for the phone field (pixxi-phone-country-trigger) on forms.
                                    </p>
                                </div>
                                <?php do_action('pixxi_forms_settings_form'); ?>
                                <div class="pixxi-form-actions">
                                    <button type="submit" name="pixxi_forms_save_settings" class="pixxi-btn pixxi-btn-primary">
                                        Save Settings
                                    </button>
                                    <button type="button" id="test-connection-btn" class="pixxi-btn pixxi-btn-secondary">
                                        Test Connection
                                    </button>
                                </div>
                            <?php else : ?>
                                <div class="pixxi-pro-locked-placeholder">
                                    <div class="pixxi-form-group">
                                        <label class="pixxi-label">Default phone country <span class="pixxi-badge pixxi-badge-pro">Pro</span></label>
                                        <select class="pixxi-input" style="max-width: 320px;" disabled>
                                            <option value="">Select country</option>
                                        </select>
                                        <p class="pixxi-help-text">Default country for the phone field (pixxi-phone-country-trigger) on forms.</p>
                                    </div>
                                    <div class="pixxi-form-group">
                                        <label class="pixxi-label">reCAPTCHA Site Key <span class="pixxi-badge pixxi-badge-pro">Pro</span></label>
                                        <input type="text" class="pixxi-input-large" placeholder="e.g. 6Lc..." disabled>
                                        <p class="pixxi-help-text">Get keys from Google reCAPTCHA. Use reCAPTCHA v2 "I'm not a robot" checkbox.</p>
                                    </div>
                                    <div class="pixxi-form-group">
                                        <label class="pixxi-label">reCAPTCHA Secret Key</label>
                                        <input type="text" class="pixxi-input-large" placeholder="e.g. 6Lc..." disabled>
                                    </div>
                                    <div class="pixxi-form-group">
                                        <label class="pixxi-label">Email notifications <span class="pixxi-badge pixxi-badge-pro">Pro</span></label>
                                        <label class="pixxi-label-inline"><input type="checkbox" disabled> Notify admin(s) on each submission</label>
                                        <div class="pixxi-form-group" style="margin-top: 8px;">
                                            <label class="pixxi-label">Admin email(s)</label>
                                            <input type="text" class="pixxi-input-large" disabled placeholder="">
                                            <p class="pixxi-help-text">Comma-separated. Default: site admin email.</p>
                                        </div>
                                        <label class="pixxi-label-inline"><input type="checkbox" disabled> Send confirmation email to submitter</label>
                                    </div>
                                    <div class="pixxi-form-group">
                                        <label class="pixxi-label">Webhooks <span class="pixxi-badge pixxi-badge-pro">Pro</span></label>
                                        <textarea class="pixxi-input-large pixxi-textarea" rows="3" disabled placeholder="https://hooks.zapier.com/..."></textarea>
                                        <p class="pixxi-help-text">One URL per line. Form data is POSTed as JSON to each URL on submission.</p>
                                    </div>
                                    <div class="pixxi-form-group">
                                        <label class="pixxi-label">API profiles <span class="pixxi-badge pixxi-badge-pro">Pro</span></label>
                                        <p class="pixxi-help-text">Use different API credentials per form. Assign a profile in Manage Forms when editing a form.</p>
                                        <button type="button" class="pixxi-btn pixxi-btn-secondary" disabled>Add API profile</button>
                                    </div>
                                    <div class="pixxi-form-actions pixxi-pro-locked-cta">
                                        <button type="submit" name="pixxi_forms_save_settings" class="pixxi-btn pixxi-btn-primary">
                                            Save Settings
                                        </button>
                                        <button type="button" id="test-connection-btn" class="pixxi-btn pixxi-btn-secondary">
                                            Test Connection
                                        </button>
                                        <a href="<?php echo esc_url('https://devmizan.com/plugins/pixxi-forms/'); ?>" target="_blank" rel="noopener" class="pixxi-btn pixxi-btn-primary">Upgrade to Pro</a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="pixxi-settings-col pixxi-settings-col-sidebar">
                    <div class="pixxi-card pixxi-card-how-to-use">
                        <div class="pixxi-card-header">
                            <h2>How to Use</h2>
                        </div>
                        <div class="pixxi-card-body">
                            <div class="pixxi-instructions">
                                <h3>Step 1: Configure API Token</h3>
                                <p>Enter your Pixxi CRM API token above and save the settings.</p>

                                <h3>Step 2: Create Forms</h3>
                                <p>Go to <a href="<?php echo esc_url(admin_url('admin.php?page=pixxi-forms-manage')); ?>">Manage Forms</a> to create your forms.</p>

                                <h3>Step 3: Use Shortcodes</h3>
                                <p>Add forms to your pages using these shortcodes:</p>
                                
                                <div class="pixxi-code-block">
                                    <strong>Listing Form (for properties):</strong><br>
                                    <code>[pixxi_listing_form form_id="your-form-id" property_id="property-id"]</code>
                                </div>

                                <div class="pixxi-code-block">
                                    <strong>General Form:</strong><br>
                                    <code>[pixxi_general_form form_id="your-form-id"]</code>
                                </div>

                                <div class="pixxi-code-block">
                                    <strong>Hide Labels (Compact Form):</strong><br>
                                    <code>[pixxi_general_form form_id="your-form-id" show_labels="no"]</code><br>
                                    <small style="color: #666;">Use show_labels="no" to hide field labels and show only placeholders</small>
                                </div>

                                <h3>Form Types</h3>
                                <ul class="pixxi-info-list">
                                    <li><strong>Listing Forms:</strong> Automatically assign leads to the listing agent. Requires a property ID.</li>
                                    <li><strong>General Forms:</strong> Flexible lead assignment to selected people in Pixxi CRM.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    function updatePixxiDepends() {
        $('[data-pixxi-depends]').each(function() {
            var depId = $(this).data('pixxi-depends');
            var $cb = $('#' + depId);
            if ($cb.length && $cb.is(':checkbox')) {
                var show = $cb.is(':checked');
                $(this).toggle(show).find('input, select, textarea').prop('disabled', !show);
            }
        });
    }
    updatePixxiDepends();
    $('#pixxi-settings-form').on('change', 'input[type="checkbox"]', updatePixxiDepends);

    $('#test-connection-btn').on('click', function(e) {
        e.preventDefault();
        
        var btn = $(this);
        var originalText = btn.text();
        btn.prop('disabled', true).text('Testing...');
        
        $.ajax({
            url: pixxiForms.ajax_url,
            method: 'POST',
            data: {
                action: 'pixxi_test_connection',
                nonce: pixxiForms.nonce
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Connection Successful',
                        text: response.data.message,
                        confirmButtonColor: '#000000'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Connection Failed',
                        text: response.data.message,
                        confirmButtonColor: '#000000'
                    });
                }
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Failed to test connection',
                    confirmButtonColor: '#000000'
                });
            },
            complete: function() {
                btn.prop('disabled', false).text(originalText);
            }
        });
    });
});
</script>

