/**
 * Show SweetAlert when returning from Stripe checkout (success/cancel/fail).
 * URL params: pixxi_license=success|cancel|fail, optional message= for fail.
 */
(function() {
    var params = new URLSearchParams(window.location.search);
    var status = params.get('pixxi_license');
    if (!status) return;

    var cleanUrl = function() {
        params.delete('pixxi_license');
        params.delete('message');
        params.delete('session_id');
        var qs = params.toString();
        var base = window.location.pathname;
        var newUrl = base + (qs ? '?' + qs : '') + (window.location.hash || '');
        window.history.replaceState({}, document.title, newUrl);
    };

    if (typeof Swal === 'undefined') {
        cleanUrl();
        return;
    }

    var darkClass = { customClass: { popup: 'pixxi-license-swal-dark' } };
    var neonBtn = { confirmButtonColor: '#39FF14' };

    if (status === 'success') {
        Swal.fire(Object.assign({
            icon: 'success',
            title: 'Success',
            text: 'We have sent your license key to your email. Please check your inbox or spam folder.',
            confirmButtonText: 'OK'
        }, darkClass, neonBtn));
    } else if (status === 'cancel') {
        Swal.fire(Object.assign({
            icon: 'info',
            title: 'Checkout cancelled',
            text: 'You cancelled the checkout. You can try again whenever you\'re ready.',
            confirmButtonText: 'OK'
        }, darkClass, neonBtn));
    } else if (status === 'fail') {
        var msg = params.get('message') || 'Something went wrong. Please try again or contact support.';
        Swal.fire(Object.assign({
            icon: 'error',
            title: 'Error',
            text: msg,
            confirmButtonText: 'OK'
        }, darkClass, neonBtn));
    }

    cleanUrl();
})();
