<?php
/**
 * Uninstall Pixxi Forms
 *
 * Runs when the plugin is deleted (not on deactivate).
 * Removes options and tables only if the user opted in via Settings.
 *
 * @package Pixxi_Forms
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Do not load the main plugin file or any other includes.
$remove_data = get_option('pixxi_forms_remove_data_on_uninstall', false);

if (!$remove_data) {
    return;
}

global $wpdb;

$tables = array(
    $wpdb->prefix . 'pixxi_forms',
    $wpdb->prefix . 'pixxi_submissions',
);

foreach ($tables as $table) {
    $wpdb->query("DROP TABLE IF EXISTS `{$table}`");
}

$options = array(
    'pixxi_forms_api_token',
    'pixxi_forms_api_url',
    'pixxi_forms_remove_data_on_uninstall',
    'pixxi_forms_default_phone_country',
    'pixxi_forms_phone_show_country_code',
);

foreach ($options as $option) {
    delete_option($option);
}
